/*
 * Decompiled with CFR 0.152.
 */
package Entity;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class PlayerSave {
    private static int health = 3;
    private static int score = 0;
    private static long time = 0L;
    private static String weapon;
    private static Color color;
    private static String[] highscores;
    private static String[] highScoresEasy;
    private static String[] highScoresNormal;
    private static String[] highScoresHard;
    private static int tripleBulletAmmo;
    private static int missilesAmmo;
    private static int beamAmmo;
    public static int tripleBulletAmmoAdd;
    public static int missilesAmmoAdd;
    public static int beamAmmoAdd;
    private static int maxTripleBulletAmmo;
    private static int maxMissilesAmmo;
    private static int maxBeamAmmo;
    private static int powerUpState;
    public static final int BULLET = 0;
    public static final int TRIPLEBULLET = 1;
    public static final int MISSILES = 2;
    public static final int BEAM = 3;
    public static final int EASY = 0;
    public static final int NORMAL = 1;
    public static final int HARD = 2;
    private static int difficulty;
    public static String difficultyString;

    static {
        highScoresEasy = new String[]{"Darryl:200", "Jake:190", "JackieZ:180", "Dame Dame:170", "Marcus:160", "Liam:150", "Andrew S:140", "Andrew B:130", "Nathaniel:120", "David:110"};
        highScoresNormal = new String[]{"Darryl:150", "Jake:140", "JackieZ:130", "Dame Dame:120", "Marcus:110", "Liam:100", "Andrew S:90", "Andrew B:80", "Nathaniel:70", "David:60"};
        highScoresHard = new String[]{"Darryl:100", "Jake:90", "JackieZ:80", "Dame Dame:70", "Marcus:60", "Liam:50", "Andrew S:40", "Andrew B:30", "Nathaniel:20", "David:10"};
        tripleBulletAmmoAdd = 20;
        missilesAmmoAdd = 10;
        beamAmmoAdd = 200;
        maxTripleBulletAmmo = 99;
        maxMissilesAmmo = 99;
        maxBeamAmmo = 999;
        difficulty = 1;
        difficultyString = "Normal";
    }

    public static void init() {
        health = 3;
        score = 0;
        time = 0L;
        powerUpState = 0;
        tripleBulletAmmo = 0;
        missilesAmmo = 0;
        beamAmmo = 0;
    }

    public static int getHealth() {
        return health;
    }

    public static void setHealth(int i) {
        health = i;
    }

    public static void addHealth(int i) {
        if ((health += i) < 0) {
            health = 0;
        }
    }

    public static void setText() {
        if (powerUpState == 3) {
            weapon = "Hyper Beam";
            color = Color.BLUE;
        } else if (powerUpState == 1) {
            weapon = "Triple Shot";
            color = Color.RED;
        } else if (powerUpState == 2) {
            weapon = "Missiles";
            color = Color.GREEN;
        } else {
            weapon = "Bullet";
            color = Color.WHITE;
        }
    }

    public static void subAmmo(int power, int ammount) {
        if (power == 3) {
            if ((beamAmmo -= ammount) < 0) {
                beamAmmo = 0;
            }
        } else if (power == 1) {
            if ((tripleBulletAmmo -= ammount) < 0) {
                tripleBulletAmmo = 0;
            }
        } else if (power == 2 && (missilesAmmo -= ammount) < 0) {
            missilesAmmo = 0;
        }
    }

    public static void addAmmo(int power) {
        if (power == 3) {
            if ((beamAmmo += beamAmmoAdd) > maxBeamAmmo) {
                beamAmmo = maxBeamAmmo;
            }
        } else if (power == 1) {
            if ((tripleBulletAmmo += tripleBulletAmmoAdd) > maxTripleBulletAmmo) {
                tripleBulletAmmo = maxTripleBulletAmmo;
            }
        } else if (power == 2 && (missilesAmmo += missilesAmmoAdd) > maxMissilesAmmo) {
            missilesAmmo = maxMissilesAmmo;
        }
    }

    public static int getAmmo(int power) {
        int i = 0;
        if (power == 3) {
            i = beamAmmo;
        } else if (power == 1) {
            i = tripleBulletAmmo;
        } else if (power == 2) {
            i = missilesAmmo;
        }
        return i;
    }

    public static void getHighScores() {
        FileReader fr = null;
        BufferedReader br = null;
        highscores = highScoresNormal;
        try {
            try {
                fr = new FileReader(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender/" + "HighScores_" + difficultyString + ".dat");
                br = new BufferedReader(fr);
                int i = 0;
                while (i < highscores.length) {
                    PlayerSave.highscores[i] = br.readLine();
                    ++i;
                }
            }
            catch (Exception e) {
                System.out.println("1");
                if (difficulty == 0) {
                    highscores = highScoresEasy;
                }
                if (difficulty == 1) {
                    highscores = highScoresNormal;
                }
                if (difficulty == 2) {
                    highscores = highScoresHard;
                }
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.out.println("2");
                }
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("2");
            }
        }
    }

    public static void setHighScores() {
        String[] tempScore = new String[]{"", "", "", "", "", "", "", "", "", ""};
        int i = 0;
        while (i < highscores.length) {
            if (score > Integer.parseInt(highscores[i].split(":")[1])) {
                int k = 0;
                int j = i;
                while (j < highscores.length) {
                    tempScore[k] = highscores[j];
                    ++k;
                    ++j;
                }
                k = 0;
                int n = i;
                while (n < highscores.length - 1) {
                    PlayerSave.highscores[n + 1] = tempScore[k];
                    ++k;
                    ++n;
                }
                String name = JOptionPane.showInputDialog("New High Score! Please Enter your name:");
                if (name == null || name.equals("")) {
                    name = "No Name";
                }
                PlayerSave.highscores[i] = String.valueOf(name) + ":" + score;
                break;
            }
            ++i;
        }
        boolean success = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender").mkdirs();
        File scoreFile = new File(String.valueOf(System.getProperty("user.home")) + "/Documents/CometDefender/" + "HighScores_" + difficultyString + ".dat");
        if (!scoreFile.exists()) {
            try {
                scoreFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            try {
                fw = new FileWriter(scoreFile);
                bw = new BufferedWriter(fw);
                int i2 = 0;
                while (i2 < highscores.length) {
                    bw.write(highscores[i2]);
                    if (i2 != highscores.length - 1) {
                        bw.newLine();
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                try {
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void drawHighScore(Graphics2D g, Font font) {
        g.setFont(font);
        g.setColor(Color.WHITE);
        int i = 0;
        while (i < highscores.length / 2) {
            g.drawString(String.valueOf(i + 1) + ". " + highscores[i].split(":")[0] + " - " + highscores[i].split(":")[1], 150, 100 + 50 * i);
            ++i;
        }
        i = 0;
        while (i < highscores.length / 2) {
            g.drawString(String.valueOf(i + 6) + ". " + highscores[i + 5].split(":")[0] + " - " + highscores[i + 5].split(":")[1], 500, 100 + 50 * i);
            ++i;
        }
    }

    public static String getWeapon() {
        return weapon;
    }

    public static Color getColor() {
        return color;
    }

    public static int getScore() {
        return score;
    }

    public static void setScore(int i) {
        score = i;
    }

    public static void addScore(int i) {
        score += i;
    }

    public static int getPowerUpState() {
        return powerUpState;
    }

    public static void setPowerUpState(int i) {
        powerUpState = i;
    }

    public static int getDifficulty() {
        return difficulty;
    }

    public static void setDifficulty(int i) {
        PlayerSave.setHighScores();
        difficulty = i;
        if (i == 0) {
            difficultyString = "Easy";
        } else if (i == 1) {
            difficultyString = "Normal";
        } else if (i == 2) {
            difficultyString = "Hard";
        }
        PlayerSave.getHighScores();
    }

    public static long getTime() {
        return time;
    }

    public static void setTime(long t) {
        time = t;
    }
}

